package com.qboxus.tictic.activitesfragments.videorecording

import android.app.Dialog
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import androidx.databinding.DataBindingUtil
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.livestreaming.activities.MulticastStreamerActivity
import com.qboxus.tictic.activitesfragments.livestreaming.model.LiveUserModel
import com.qboxus.tictic.activitesfragments.shoping.AddProducts.ListProducts
import com.qboxus.tictic.simpleclasses.DateOprations
import com.qboxus.tictic.simpleclasses.Dialogs
import com.qboxus.tictic.simpleclasses.Functions.cancelLoader
import com.qboxus.tictic.simpleclasses.Functions.checkStatus
import com.qboxus.tictic.simpleclasses.Functions.getHeaders
import com.qboxus.tictic.simpleclasses.Functions.getSharedPreference
import com.qboxus.tictic.simpleclasses.Functions.isOpenGLVersionSupported
import com.qboxus.tictic.simpleclasses.Functions.isWorkManagerRunning
import com.qboxus.tictic.simpleclasses.Functions.showLoader
import com.qboxus.tictic.simpleclasses.TicTicApp
import com.qboxus.tictic.simpleclasses.Variables
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.qboxus.tictic.databinding.FragmentVideoCreationBinding
import com.qboxus.tictic.interfaces.FragmentCallBack
import com.volley.plus.VPackages.VolleyRequest
import org.json.JSONObject

class CreateContentFragment(var fragmentCallBack: FragmentCallBack) : BottomSheetDialogFragment(), View.OnClickListener {

    var streamingId = ""
    lateinit var binding: FragmentVideoCreationBinding

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding =DataBindingUtil.inflate(inflater,R.layout.fragment_video_creation, container, false)

        binding.goBack.setOnClickListener(this)
        binding.postArgearLayout.setOnClickListener(this)
        binding.liveLayout.setOnClickListener(this)
        binding.createDish.visibility = View.VISIBLE
        binding.createDish.setOnClickListener(this)
        binding.spacelayout.setOnClickListener(this)
        return binding.root
    }


    override fun onClick(v: View) {
        when (v.id) {
            R.id.live_layout -> {
                liveStreamingId
            }

            R.id.goBack -> dismiss()
            R.id.post_argear_layout -> {
                val isOpenGLSupported = isOpenGLVersionSupported(context, 0x00030001)
                if (isOpenGLSupported) {
                    openVideoCamera()
                } else {
                    Toast.makeText(
                        binding.root.context,
                       requireContext().getString(R.string.your_device_opengl_verison_is_not_compatible_to_use_this_feature),
                        Toast.LENGTH_SHORT
                    ).show()
                }
            }

            R.id.spacelayout->{
                dismiss()
                if(fragmentCallBack!=null){
                    fragmentCallBack.onResponce(Bundle())
                }
            }

            R.id.createDish -> {
                    dismiss()

                    val intent = Intent(context, ListProducts::class.java)
                    startActivity(intent)
                    requireActivity().overridePendingTransition(R.anim.in_from_bottom, R.anim.out_to_top)

            }

        }
    }



    fun openVideoCamera() {
        if (isWorkManagerRunning(requireContext(), "videoUpload")) {
            Toast.makeText(
                binding.root.context,
                requireContext().getString(R.string.video_already_in_progress),
                Toast.LENGTH_SHORT
            ).show()
            Dialogs.showAlert(
                activity,
                requireContext().getString(R.string.app_name),
                requireContext().getString(R.string.video_already_in_progress)
            )
        } else {
            dismiss()
            val intent = Intent(binding.root.context, com.qboxus.tictic.activitesfragments.videorecording.VideoRecoderActivity::class.java)
            startActivity(intent)
            requireActivity().overridePendingTransition(R.anim.in_from_bottom, R.anim.out_to_top)
        }
    }

    private val liveStreamingId: Unit
        private get() {
            val parameters = JSONObject()
            try {
                parameters.put(
                    "user_id",
                    getSharedPreference(binding.root.context).getString(com.qboxus.tictic.simpleclasses.Variables.U_ID, "0")
                )
                parameters.put("started_at", DateOprations.getCurrentDate("yyyy-MM-dd HH:mm:ss"))
            } catch (e: Exception) {
                e.printStackTrace()
            }
            showLoader(activity, false, false)
            VolleyRequest.JsonPostRequest(
                activity,
                com.qboxus.tictic.apiclasses.ApiLinks.liveStream,
                parameters,
                getHeaders(binding.root.context)
            ) { resp ->
                checkStatus(activity, resp)
                cancelLoader()
                try {
                    val jsonObject = JSONObject(resp)
                    val code = jsonObject.optString("code")
                    if (code == "200") {
                        val msgObj = jsonObject.getJSONObject("msg")
                        val streamingObj = msgObj.getJSONObject("LiveStreaming")
                        streamingId = streamingObj.optString("id")
                        gotoRoleActivity()
                    }
                } catch (e: Exception) {
                    Log.d(com.qboxus.tictic.Constants.tag, "Exception : $e")
                }
            }
        }



    fun gotoRoleActivity() {
        val model=LiveUserModel()
        model.userId=getSharedPreference(binding.root.context).getString(Variables.U_ID, "")
        model.userName = getSharedPreference(binding.root.context).getString(Variables.U_NAME, "")
        model.userPicture=getSharedPreference(binding.root.context).getString(Variables.U_PIC, "")
        model.streamingId =streamingId
        model.isDualStreaming = true
        model.onlineType ="multicast"

        val intent = Intent()
        val myApp = requireActivity().application as TicTicApp
        myApp.engineConfig().uid = getSharedPreference(binding.root.context).getString(Variables.U_ID, "")
        myApp.engineConfig().channelName = streamingId

        intent.putExtra("data",model)
        intent.setClass(requireActivity(), MulticastStreamerActivity::class.java)
        dismiss()
        startActivity(intent)
    }

}